#!/bin/bash
echo "╔══════════════════════════════════════╗"
echo "║      Caring AI — Installer           ║"
echo "╚══════════════════════════════════════╝"
echo ""

# Check for Node.js
if ! command -v node &>/dev/null; then
  echo "Node.js is required but not installed."
  echo "Install it from https://nodejs.org (LTS recommended)"
  exit 1
fi

NODE_VER=$(node -v | sed 's/v//' | cut -d. -f1)
echo "✓ Node.js $(node -v) detected"

# Install dependencies
echo "Installing dependencies..."
npm install --production 2>&1 | tail -1
echo "✓ Dependencies installed"

# Create LaunchAgent for auto-start
PLIST="$HOME/Library/LaunchAgents/com.caringconsulting.caring-ai.plist"
INSTALL_DIR="$(cd "$(dirname "$0")" && pwd)"

cat > "$PLIST" << PLISTEOF
<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
  <key>Label</key>
  <string>com.caringconsulting.caring-ai</string>
  <key>ProgramArguments</key>
  <array>
    <string>$(which node)</string>
    <string>${INSTALL_DIR}/src/index.js</string>
  </array>
  <key>WorkingDirectory</key>
  <string>${INSTALL_DIR}</string>
  <key>RunAtLoad</key>
  <true/>
  <key>KeepAlive</key>
  <true/>
  <key>StandardOutPath</key>
  <string>${HOME}/.caring-ai/server.log</string>
  <key>StandardErrorPath</key>
  <string>${HOME}/.caring-ai/server.log</string>
</dict>
</plist>
PLISTEOF

echo "✓ Auto-start configured"

# Start the server
launchctl bootout gui/$(id -u) "$PLIST" 2>/dev/null
launchctl bootstrap gui/$(id -u) "$PLIST"
echo "✓ Caring AI Server started"

echo ""
echo "Done! Open http://localhost:11435 to manage your AI models."
echo "The server starts automatically when you log in."
